/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.more_bows_and_arrows.mixin;

import neoforge.com.cursee.more_bows_and_arrows.core.entity.TieredArrowEntity;
import neoforge.com.cursee.more_bows_and_arrows.core.item.TieredBowItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public class CommonAbstractArrowMixin {
    @Inject(method={"onHitEntity"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/entity/projectile/AbstractArrow;doPostHurtEffects(Lnet/minecraft/world/entity/LivingEntity;)V")})
    private void injected$onHitEntity(EntityHitResult result, CallbackInfo ci) {
        Player player;
        AbstractArrow instance = (AbstractArrow)this;
        Entity entity = result.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        Entity entity2 = instance.getOwner();
        if (entity2 instanceof Player && (entity2 = (player = (Player)entity2).getMainHandItem().getItem()) instanceof TieredBowItem) {
            TieredBowItem tieredBowItem = (TieredBowItem)entity2;
            livingEntity.hurt(livingEntity.damageSources().playerAttack(player), tieredBowItem.tier.bonusDamage());
            tieredBowItem.playerAttacksEntity(player, livingEntity);
        }
        if (instance instanceof TieredArrowEntity) {
            TieredArrowEntity tieredArrowEntity = (TieredArrowEntity)instance;
            livingEntity.hurt(livingEntity.damageSources().arrow(instance, tieredArrowEntity.getOwner()), tieredArrowEntity.bonusDamage());
        }
    }

    @Inject(method={"onHitBlock"}, at={@At(value="TAIL")})
    private void injected$onHitBlock(BlockHitResult result, CallbackInfo ci) {
        Player player;
        AbstractArrow instance = (AbstractArrow)this;
        Entity entity = instance.getOwner();
        if (entity instanceof Player && (entity = (player = (Player)entity).getMainHandItem().getItem()) instanceof TieredBowItem) {
            TieredBowItem tieredBowItem = (TieredBowItem)entity;
            tieredBowItem.playerAttacksBlock(player, result);
        }
    }
}

